﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Diagnostics;

namespace CashierCrisis
{
    public enum LogCategory
    {
        General,
        Exception,
        Game
    }

    public static class Log
    {
        private static List<string> lines;
   
        static Log()
        {
            lines = new List<string>();
        }

        [Conditional("DEBUG")]
        public static void WriteLine(LogCategory category, string line)
        {
            string logLine = string.Format("[Log] {0} : {1}", category, line);
            lines.Add(logLine);
            Debug.WriteLine(logLine);
        }


        public static string GetDate()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(DateTime.Now.Month);
            sb.Append(DateTime.Now.Day);
            sb.Append(DateTime.Now.Year);
            sb.Append(DateTime.Now.Hour);
            sb.Append(DateTime.Now.Minute);
            return sb.ToString();
        }

        public static void Save(string filename)
        {
            StringBuilder fullFileName = new StringBuilder();
            fullFileName.Append(filename);
            fullFileName.Append(GetDate());
            fullFileName.Append(".txt");

            using (TextWriter writer = new StreamWriter(Path.Combine(Directory.GetCurrentDirectory(),
                fullFileName.ToString())))
            {
                writer.WriteLine("CasherCrisis Log");
                writer.WriteLine(DateTime.Now);
                foreach (string line in lines)
                {
                    writer.WriteLine(line);
                }
                writer.Close();
            }
        }
      
    }
}
